ORCA/M Asm65816 2.1.0

0001 8F64                       Blanks off 
0002 8F64                       String asis 
0003 8F64
0004 8F64              **********************************************************************
0005 8F64              *
0006 8F64              *          Copyright Apple Computer, Inc. 1986-1988
0007 8F64              *                    All rights reserved
0008 8F64              *                   Written by Dan Oliver
0009 8F64              *
0010 8F64              *               *** C O N F I D E N T I A L ***
0011 8F64              *
0012 8F64              * 26 Oct 88         Harry Yee
0013 8F64              * Inserted exit routine to pop 14 bytes.
0014 8F64              *
0015 8F64              * 10/2788           Dan O.
0016 8F64              * Added shutdown entry point.
0017 8F64              * Added allocate1 entry point.
0018 8F64              *
0019 8F64              **********************************************************************
0020 8F64
0021 8F64              IncBusyFlg equ $E10064 
0022 8F64              DecBusyFlg equ $E10068 
0023 8F64
0024 8F64
0025 8F64                       INCLUDE 'all.macros' 
0026 8F64
0027 8F64
0028 8F64              ;==========================================================================
0029 8F64              ;          Push a direct page address.
0030 8F64              ;
0031 8F64              ;   IN:    a = direct page offset.
0032 8F64              ;==========================================================================
0033 8F64                       EXPORT pushDpage 
0034 8F64              pushDpage PROC 
0035 8F64
0036 8F64 FA                    plx                            Get return address.
0037 8F65
0038 8F65 F4 00 00              pea   0                        Zero page address.
0039 8F68 48                    pha                            Zero page offset.
0040 8F69 7B                    tdc                            Zero page starting address.
0041 8F6A 18                    clc   
0042 8F6B 63 01                 adc   1,s
0043 8F6D 83 01                 sta   1,s
0044 8F6F
0045 8F6F DA                    phx                            Put return address back on stack.
0046 8F70
0047 8F70 60                    rts   
0048 8F71
0049 8F71                       ENDP 
0050 8F71
0051 8F71
0052 8F71              ;==========================================================================
0053 8F71              ;
0054 8F71              ;          Push a long value from direct page.
0055 8F71              ;
0056 8F71              ;   IN:  x = offset to direct page value to be pushed.
0057 8F71              ;
0058 8F71              ;==========================================================================
0059 8F71                       EXPORT pushDlong 
0060 8F71              pushDlong PROC 
0061 8F71
0062 8F71 7A                    ply                            Grab return address.
0063 8F72
0064 8F72 B5 02                 lda   <2,x
0065 8F74 48                    pha   
0066 8F75 B5 00                 lda   <0,x
0067 8F77 48                    pha   
0068 8F78
0069 8F78 5A                    phy                            Put back return address and return.
0070 8F79
0071 8F79 60                    rts   
0072 8F7A
0073 8F7A                       ENDP 
0074 8F7A
0075 8F7A
0076 8F7A              ;==========================================================================
0077 8F7A              ;
0078 8F7A              ;          Allocate a block of memory.
0079 8F7A              ;
0080 8F7A              ;   IN:    y = ID number.
0081 8F7A              ;          a = number of bytes.
0082 8F7A              ;
0083 8F7A              ;  OUT:    Carry clear if handle allocated, a+x = handle.
0084 8F7A              ;          Carry set if error, y = error returned by Memory Manager.
0085 8F7A              ;
0086 8F7A              ;==========================================================================
0087 8F7A              ;
0088 8F7A              allocate1 PROC EXPORT 
0089 8F7A              ;
0090 8F7A A2 00 00              ldx   #0                       Anywhere, anyhow.
0091 8F7D 80 03                 bra   allocate3
0092 8F7F              ;
0093 8F7F              ;
0094 8F7F                       EXPORT allocate2 
0095 8F7F A2 10 40     allocate2 ldx   #%0100000000010000      Fixed, May not cross bank boundary.
0096 8F82
0097 8F82              ;
0098 8F82              ; = = = = = = = = = = = = = = = = = = = = = = = =
0099 8F82              ;          Allocate a block of memory.
0100 8F82              ; = = = = = = = = = = = = = = = = = = = = = = = =
0101 8F82              ;
0102 8F82              ;   IN:    y = ID number.
0103 8F82              ;          x = attributes.
0104 8F82              ;          a = number of bytes.
0105 8F82              ;
0106 8F82              ;  OUT:    Carry clear if handle allocated, a+x = handle.
0107 8F82              ;          Carry set if error, y = error returned by Memory Manager.
0108 8F82              ;
0109 8F82                       EXPORT allocate3 
0110 8F82              allocate3                               ;       
0111 8F82
0112 8F82 48                    pha                            Space for returned handle.
0113 8F83 48                    pha   
0114 8F84 F4 00 00              pea   0                        High word of size.
0115 8F87 48                    pha                            Pass low word of size.
0116 8F88 5A                    phy                            Pass ID number.
0117 8F89 DA                    phx                            Pass attributes.
0118 8F8A 48                    pha                            Address doesn't matter.
0119 8F8B 48                    pha   
0120 8F8C A2 02 09 22           _NewHandle 
0121 8F93 A8                    tay                            Return error code in Y.
0122 8F94 68                    pla                            Return handle in a+x.
0123 8F95 FA                    plx   
0124 8F96
0125 8F96 60                    rts   
0126 8F97
0127 8F97                       ENDP 
0128 8F97
0129 8F97
0130 8F97              ;==========================================================================
0131 8F97              ;
0132 8F97              ;          Do setup for tool call.
0133 8F97              ;
0134 8F97              ;   IN:    a+y = handle to data area.
0135 8F97              ;
0136 8F97              ;  OUT:    Carry clear if no error.
0137 8F97              ;          Carry set if null data pointer, y = error code.
0138 8F97              ;
0139 8F97              ;==========================================================================
0140 8F97                       EXPORT startup 
0141 8F97              startup  PROC 
0142 8F97 22 64 00 E1           jsl   IncBusyFlg
0143 8F9B
0144 8F9B FA                    plx                            Get return address.
0145 8F9C
0146 8F9C 0B                    phd                            Save caller's direct page.
0147 8F9D 8B                    phb                            Save caller's data page.
0148 8F9E
0149 8F9E 5B                    tcd                            Switch to my direct page.
0150 8F9F 4B                    phk                            Switch to this data bank.
0151 8FA0 AB                    plb   
0152 8FA1
0153 8FA1 DA                    phx                            Put return address back on stack.
0154 8FA2
0155 8FA2 60                    rts   
0156 8FA3
0157 8FA3              ;
0158 8FA3              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
0159 8FA3              ; Entry points for function exits.
0160 8FA3              ;
0161 8FA3              ; These are shared by Window manager and Menu Manager.
0162 8FA3              ; Those routines starting with E expect an error code
0163 8FA3              ; in the y-reg.  Routines without an E do not return
0164 8FA3              ; an error.
0165 8FA3              ;
0166 8FA3              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
0167 8FA3              ;
0168 8FA3              ;   IN:    y = error code.
0169 8FA3              ;
0170 8FA3                       EXPORT pop0bytes 
0171 8FA3              pop0bytes  
0172 8FA3 A0 00 00              ldy   #0                       ; no error
0173 8FA6                       EXPORT Epop0bytes 
0174 8FA6              Epop0bytes  
0175 8FA6 A2 00 00              ldx   #0
0176 8FA9 80 56                 bra   shutdown
0177 8FAB
0178 8FAB                       EXPORT pop2bytes 
0179 8FAB              pop2bytes                               ;       
0180 8FAB A0 00 00              ldy   #0                       ; no error
0181 8FAE                       EXPORT Epop2bytes 
0182 8FAE              Epop2bytes  
0183 8FAE A2 02 00              ldx   #2
0184 8FB1 80 4E                 bra   shutdown
0185 8FB3
0186 8FB3                       EXPORT pop4bytes 
0187 8FB3              pop4bytes                               ;       
0188 8FB3 A0 00 00              ldy   #0                       ; no error
0189 8FB6                       EXPORT Epop4bytes 
0190 8FB6              Epop4bytes  
0191 8FB6 A2 04 00              ldx   #4
0192 8FB9 80 46                 bra   shutdown
0193 8FBB
0194 8FBB                       EXPORT pop6bytes 
0195 8FBB              pop6bytes                               ;       
0196 8FBB A0 00 00              ldy   #0                       ; no error
0197 8FBE                       EXPORT Epop6bytes 
0198 8FBE              Epop6bytes  
0199 8FBE A2 06 00              ldx   #6
0200 8FC1 80 3E                 bra   shutdown
0201 8FC3
0202 8FC3                       EXPORT pop8bytes 
0203 8FC3              pop8bytes                               ;       
0204 8FC3 A0 00 00              ldy   #0                       ; no error
0205 8FC6                       EXPORT Epop8bytes 
0206 8FC6              Epop8bytes  
0207 8FC6 A2 08 00              ldx   #8
0208 8FC9 80 36                 bra   shutdown
0209 8FCB
0210 8FCB                       EXPORT pop10bytes 
0211 8FCB              pop10bytes                              ;       
0212 8FCB A0 00 00              ldy   #0                       ; no error
0213 8FCE                       EXPORT Epop10bytes 
0214 8FCE              Epop10bytes  
0215 8FCE A2 0A 00              ldx   #10
0216 8FD1 80 2E                 bra   shutdown
0217 8FD3
0218 8FD3                       EXPORT pop12bytes 
0219 8FD3              pop12bytes                              ;       
0220 8FD3 A0 00 00              ldy   #0                       ; no error
0221 8FD6                       EXPORT Epop12bytes 
0222 8FD6              Epop12bytes  
0223 8FD6 A2 0C 00              ldx   #12
0224 8FD9 80 26                 bra   shutdown
0225 8FDB
0226 8FDB                       EXPORT pop14bytes 
0227 8FDB              pop14bytes  
0228 8FDB A0 00 00              ldy   #0                       ; no error
0229 8FDE                       EXPORT Epop14bytes 
0230 8FDE              Epop14bytes  
0231 8FDE A2 0E 00              ldx   #14
0232 8FE1 80 1E                 bra   shutdown
0233 8FE3
0234 8FE3                       EXPORT pop16bytes 
0235 8FE3              pop16bytes                              ;       
0236 8FE3 A0 00 00              ldy   #0                       ; no error
0237 8FE6                       EXPORT Epop16bytes 
0238 8FE6              Epop16bytes  
0239 8FE6 A2 10 00              ldx   #16
0240 8FE9 80 16                 bra   shutdown
0241 8FEB
0242 8FEB                       EXPORT pop18bytes 
0243 8FEB              pop18bytes                              ;       
0244 8FEB A0 00 00              ldy   #0                       ; no error
0245 8FEE                       EXPORT Epop18bytes 
0246 8FEE              Epop18bytes  
0247 8FEE A2 12 00              ldx   #18
0248 8FF1 80 0E                 bra   shutdown
0249 8FF3
0250 8FF3                       EXPORT pop26bytes 
0251 8FF3              pop26bytes                              ;       
0252 8FF3 A0 00 00              ldy   #0                       ; no error
0253 8FF6                       EXPORT Epop26bytes 
0254 8FF6              Epop26bytes  
0255 8FF6 A2 1A 00              ldx   #26
0256 8FF9 80 06                 bra   shutdown
0257 8FFB
0258 8FFB                       EXPORT pop32bytes 
0259 8FFB              pop32bytes                              ;       
0260 8FFB A0 00 00              ldy   #0                       ; no error
0261 8FFE                       EXPORT Epop32bytes 
0262 8FFE              Epop32bytes  
0263 8FFE A2 20 00              ldx   #32
0264 9001
0265 9001              ;==========================================================================
0266 9001              ;                   ShutDown
0267 9001              ;
0268 9001              ;  IN:     y = error code, zero if no error.
0269 9001              ;          x = number of bytes to pop.
0270 9001              ;          Startup must have been called.
0271 9001              ;
0272 9001              ;==========================================================================
0273 9001              ;
0274 9001                       EXPORT shutdown 
0275 9001              shutdown  
0276 9001 22 68 00 E1           jsl   DecBusyFlg
0277 9005              ;
0278 9005              ; --- Restore saved parameters from startupCall --------------------------
0279 9005              ;
0280 9005 AB                    plb                            Restore original data bank.
0281 9006
0282 9006              ;
0283 9006              ; --- Move return addresses over top of input parameters -----------------
0284 9006              ;
0285 9006 3B                    tsc   
0286 9007 5B                    tcd   
0287 9008 A3 07                 lda   7,s
0288 900A 95 07                 sta   7,x
0289 900C A3 05                 lda   5,s
0290 900E 95 05                 sta   5,x
0291 9010 A3 03                 lda   3,s
0292 9012 95 03                 sta   3,x
0293 9014
0294 9014              ;
0295 9014              ; --- Adjust stact for popped parameters ---
0296 9014              ;
0297 9014 2B                    pld                            Get original direct page pointer.
0298 9015
0299 9015 3B                    tsc                            Current stack,
0300 9016 DA                    phx   
0301 9017 18                    clc   
0302 9018 63 01                 adc   1,s                      plus number of bytes popped,
0303 901A 1B                    tcs                            equals new stack.
0304 901B              ;
0305 901B 98                    tya                            Return error code in Y.
0306 901C C9 01 00              cmp   #1                       Set carry if error.
0307 901F
0308 901F 6B                    rtl   
0309 9020
0310 9020                       ENDP 
0311 9020
0312 9020                       END   
